<?php

namespace app\controllers;

use Yii;
use yii\web\Controller;
use yii\filters\AccessControl;
use yii\data\ActiveDataProvider;
use app\models\Application;
use app\models\ReadingForm;

class ApplicationController extends Controller
{
    public function behaviors()
    {
        return [
            'access' => [
                'class' => AccessControl::class,
                'rules' => [
                    [
                        'allow' => true,
                        'roles' => ['@'],
                    ],
                ],
            ],
        ];
    }

    public function actionIndex()
    {
        $dataProvider = new ActiveDataProvider([
            'query' => Application::find()
                ->where(['user_id' => Yii::$app->user->id])
                ->orderBy(['date' => SORT_DESC]),
            'pagination' => [
                'pageSize' => 10,
            ],
        ]);

        return $this->render('index', [
            'dataProvider' => $dataProvider,
        ]);
    }

    public function actionCreate()
    {
        $model = new ReadingForm();
        $model->date = date('Y-m-d');

        if (Yii::$app->request->isPost) {
            if ($model->load(Yii::$app->request->post())) {
                $model->loadPreviousReadings(Yii::$app->user->id);

                $action = Yii::$app->request->post('action');

                if ($action === 'calculate') {
                    $model->calculate();
                } elseif ($action === 'submit') {
                    $model->calculate();

                    if ($model->save(Yii::$app->user->id)) {
                        Yii::$app->session->setFlash('success',
                            'Показания успешно переданы! Заявка отправлена на рассмотрение администратору.'
                        );
                        return $this->redirect(['index']);
                    }
                }
            }
        } else {
            $model->load(Yii::$app->request->get());
            if ($model->category) {
                $model->loadPreviousReadings(Yii::$app->user->id);
                $model->calculate();
            }
        }

        return $this->render('create', [
            'model' => $model,
        ]);
    }

    public function actionRecalculate()
    {
        $model = new ReadingForm();

        if ($model->load(Yii::$app->request->post())) {
            $model->loadPreviousReadings(Yii::$app->user->id);
            $model->calculate();
        }

        return $this->render('create', [
            'model' => $model,
        ]);
    }
}