<?php

use yii\helpers\Html;

/** @var yii\web\View $this */

$this->title = 'Панель администратора';
$this->params['breadcrumbs'][] = $this->title;

$recentApplications = \app\models\Application::find()
    ->joinWith('user')
    ->orderBy(['created_at' => SORT_DESC])
    ->limit(5)
    ->all();
?>

<div class="admin-index">
    <div class="admin-container">
        <div class="admin-header">
            <div class="header-content">
                <h1 class="page-title"><?= Html::encode($this->title) ?></h1>
                <p class="page-subtitle">Управление системой и мониторинг заявок</p>
            </div>
            <div class="header-stats">
                <div class="stat-item">
                    <div class="stat-icon total">
                        <i class="fas fa-file-alt"></i>
                    </div>
                    <div class="stat-info">
                        <span class="stat-number"><?= \app\models\Application::find()->count() ?></span>
                        <span class="stat-label">Всего заявок</span>
                    </div>
                </div>
                <div class="stat-item">
                    <div class="stat-icon new">
                        <i class="fas fa-clock"></i>
                    </div>
                    <div class="stat-info">
                        <span class="stat-number"><?= \app\models\Application::find()->where(['status' => 'new'])->count() ?></span>
                        <span class="stat-label">Новые</span>
                    </div>
                </div>
                <div class="stat-item">
                    <div class="stat-icon completed">
                        <i class="fas fa-check-circle"></i>
                    </div>
                    <div class="stat-info">
                        <span class="stat-number"><?= \app\models\Application::find()->where(['status' => 'completed'])->count() ?></span>
                        <span class="stat-label">Завершено</span>
                    </div>
                </div>
            </div>
        </div>

        <div class="admin-grid">
            <div class="admin-card main-card">
                <div class="card-header">
                    <div class="card-title-section">
                        <div class="card-icon">
                            <i class="fas fa-history"></i>
                        </div>
                        <div>
                            <h3 class="card-title">Последние заявки</h3>
                            <p class="card-subtitle">Недавно созданные заявки пользователей</p>
                        </div>
                    </div>
                    <?= Html::a('Все заявки', ['/admin/applications'], ['class' => 'btn-view-all']) ?>
                </div>
                <div class="card-body">
                    <?php if ($recentApplications): ?>
                        <div class="applications-list">
                            <?php foreach ($recentApplications as $app): ?>
                                <div class="application-item" onclick="window.location='<?= \yii\helpers\Url::to(['view', 'id' => $app->id]) ?>'">
                                    <div class="application-avatar">
                                        <div class="avatar-circle">
                                            <?= strtoupper(substr($app->user->first_name, 0, 1) . substr($app->user->last_name, 0, 1)) ?>
                                        </div>
                                    </div>
                                    <div class="application-content">
                                        <div class="application-header">
                                            <h4 class="user-name"><?= $app->user->first_name ?> <?= $app->user->last_name ?></h4>
                                            <span class="application-date"><?= date('d.m.Y H:i', strtotime($app->created_at)) ?></span>
                                        </div>
                                        <div class="application-details">
                                            <div class="application-category">
                                                <i class="fas fa-<?= $app->category === 'electricity' ? 'bolt' : ($app->category === 'gas' ? 'fire' : 'tint') ?>"></i>
                                                <?= $app->getCategoryName() ?>
                                            </div>
                                            <div class="application-amount">
                                                <?= number_format($app->amount, 2, ',', ' ') ?> руб.
                                            </div>
                                        </div>
                                        <div class="application-footer">
                                            <span class="status-badge <?= $app->status ?>"><?= $app->getStatusName() ?></span>
                                            <div class="application-actions">
                                                <i class="fas fa-chevron-right"></i>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            <?php endforeach; ?>
                        </div>
                    <?php else: ?>
                        <div class="empty-state">
                            <div class="empty-icon">
                                <i class="fas fa-file-alt"></i>
                            </div>
                            <h4>Нет заявок</h4>
                            <p>Заявки от пользователей появятся здесь</p>
                        </div>
                    <?php endif; ?>
                </div>
            </div>

            <div class="admin-sidebar">
                <div class="admin-card quick-actions">
                    <div class="card-header">
                        <h3 class="card-title">Быстрые действия</h3>
                    </div>
                    <div class="card-body">
                        <div class="actions-list">
                            <?= Html::a('<i class="fas fa-list"></i>Все заявки', ['/admin/applications'], ['class' => 'action-item']) ?>
                            <?= Html::a('<i class="fas fa-users"></i>Пользователи', ['admin/view'], ['class' => 'action-item']) ?>
                            <?= Html::a('<i class="fas fa-cog"></i>Настройки', ['admin/statistics'], ['class' => 'action-item']) ?>
                            <?= Html::a('<i class="fas fa-chart-bar"></i>Отчеты', ['admin/applications'], ['class' => 'action-item']) ?>
                        </div>
                    </div>
                </div>

                <div class="admin-card system-info">
                    <div class="card-header">
                        <h3 class="card-title">Системная информация</h3>
                    </div>
                    <div class="card-body">
                        <div class="info-list">
                            <div class="info-item">
                                <i class="fas fa-calendar"></i>
                                <span class="info-label">Дата сервера:</span>
                                <span class="info-value"><?= date('d.m.Y') ?></span>
                            </div>
                            <div class="info-item">
                                <i class="fas fa-clock"></i>
                                <span class="info-label">Время сервера:</span>
                                <span class="info-value"><?= date('H:i:s') ?></span>
                            </div>
                            <div class="info-item">
                                <i class="fas fa-database"></i>
                                <span class="info-label">Заявок сегодня:</span>
                                <span class="info-value"><?= \app\models\Application::find()->where(['>=', 'created_at', date('Y-m-d 00:00:00')])->count() ?></span>
                            </div>
                            <div class="info-item">
                                <i class="fas fa-user-plus"></i>
                                <span class="info-label">Пользователей:</span>
                                <span class="info-value"><?= \app\models\User::find()->count() ?></span>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<style>
    /* Main Container */
    .admin-index {
        min-height: 100vh;
        background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
        padding: 2rem 1rem;
    }

    .admin-container {
        max-width: 1400px;
        margin: 0 auto;
    }

    /* Header */
    .admin-header {
        margin-bottom: 2rem;
    }

    .header-content {
        margin-bottom: 2rem;
    }

    .page-title {
        font-size: 2.5rem;
        font-weight: 700;
        color: white;
        margin: 0 0 0.5rem 0;
    }

    .page-subtitle {
        color: rgba(255, 255, 255, 0.9);
        font-size: 1.1rem;
        margin: 0;
    }

    /* Stats */
    .header-stats {
        display: grid;
        grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
        gap: 1.5rem;
        margin-bottom: 2rem;
    }

    .stat-item {
        background: rgba(255, 255, 255, 0.1);
        backdrop-filter: blur(10px);
        border: 1px solid rgba(255, 255, 255, 0.2);
        border-radius: 16px;
        padding: 1.5rem;
        display: flex;
        align-items: center;
        gap: 1rem;
        color: white;
        transition: all 0.3s ease;
    }

    .stat-item:hover {
        background: rgba(255, 255, 255, 0.15);
        transform: translateY(-2px);
    }

    .stat-icon {
        width: 60px;
        height: 60px;
        border-radius: 12px;
        display: flex;
        align-items: center;
        justify-content: center;
        font-size: 1.5rem;
    }

    .stat-icon.total {
        background: linear-gradient(135deg, #667eea, #764ba2);
    }

    .stat-icon.new {
        background: linear-gradient(135deg, #ff6b6b, #ee5a24);
    }

    .stat-icon.completed {
        background: linear-gradient(135deg, #2ed573, #1dd1a1);
    }

    .stat-info {
        display: flex;
        flex-direction: column;
    }

    .stat-number {
        font-size: 2rem;
        font-weight: 700;
        line-height: 1;
    }

    .stat-label {
        font-size: 0.9rem;
        opacity: 0.9;
        margin-top: 0.25rem;
    }

    /* Grid Layout */
    .admin-grid {
        display: grid;
        grid-template-columns: 1fr 350px;
        gap: 2rem;
    }

    /* Cards */
    .admin-card {
        background: rgba(255, 255, 255, 0.95);
        backdrop-filter: blur(20px);
        border-radius: 20px;
        box-shadow: 0 10px 40px rgba(0, 0, 0, 0.1);
        overflow: hidden;
    }

    .main-card {
        grid-column: 1;
    }

    .admin-sidebar {
        grid-column: 2;
        display: flex;
        flex-direction: column;
        gap: 1.5rem;
    }

    .card-header {
        padding: 1.5rem 2rem;
        border-bottom: 1px solid #e8eeff;
        display: flex;
        justify-content: space-between;
        align-items: center;
    }

    .card-title-section {
        display: flex;
        align-items: center;
        gap: 1rem;
    }

    .card-icon {
        width: 50px;
        height: 50px;
        background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
        border-radius: 12px;
        display: flex;
        align-items: center;
        justify-content: center;
        color: white;
        font-size: 1.25rem;
    }

    .card-title {
        margin: 0;
        color: #2c3e50;
        font-size: 1.5rem;
        font-weight: 600;
    }

    .card-subtitle {
        margin: 0.25rem 0 0 0;
        color: #7f8c8d;
        font-size: 0.9rem;
    }

    .btn-view-all {
        background: #667eea;
        color: white;
        padding: 0.5rem 1rem;
        border-radius: 8px;
        text-decoration: none;
        font-size: 0.9rem;
        font-weight: 500;
        transition: all 0.3s ease;
    }

    .btn-view-all:hover {
        background: #5a6fd8;
        transform: translateY(-1px);
        text-decoration: none;
        color: white;
    }

    .card-body {
        padding: 1.5rem 2rem;
    }

    /* Applications List */
    .applications-list {
        display: flex;
        flex-direction: column;
        gap: 1rem;
    }

    .application-item {
        display: flex;
        align-items: center;
        gap: 1rem;
        padding: 1.25rem;
        background: #f8faff;
        border: 1px solid #e8eeff;
        border-radius: 12px;
        cursor: pointer;
        transition: all 0.3s ease;
        text-decoration: none;
        color: inherit;
    }

    .application-item:hover {
        background: white;
        border-color: #667eea;
        transform: translateY(-2px);
        box-shadow: 0 4px 15px rgba(102, 126, 234, 0.15);
        text-decoration: none;
        color: inherit;
    }

    .application-avatar {
        flex-shrink: 0;
    }

    .avatar-circle {
        width: 50px;
        height: 50px;
        background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
        border-radius: 50%;
        display: flex;
        align-items: center;
        justify-content: center;
        color: white;
        font-weight: 600;
        font-size: 1rem;
    }

    .application-content {
        flex: 1;
        min-width: 0;
    }

    .application-header {
        display: flex;
        justify-content: space-between;
        align-items: flex-start;
        margin-bottom: 0.5rem;
    }

    .user-name {
        margin: 0;
        color: #2c3e50;
        font-size: 1.1rem;
        font-weight: 600;
    }

    .application-date {
        color: #7f8c8d;
        font-size: 0.85rem;
        white-space: nowrap;
    }

    .application-details {
        display: flex;
        justify-content: space-between;
        align-items: center;
        margin-bottom: 0.75rem;
    }

    .application-category {
        display: flex;
        align-items: center;
        gap: 0.5rem;
        color: #667eea;
        font-weight: 500;
        font-size: 0.9rem;
    }

    .application-amount {
        color: #27ae60;
        font-weight: 700;
        font-size: 1rem;
    }

    .application-footer {
        display: flex;
        justify-content: space-between;
        align-items: center;
    }

    .application-actions {
        color: #667eea;
        font-size: 0.9rem;
        transition: transform 0.3s ease;
    }

    .application-item:hover .application-actions {
        transform: translateX(3px);
    }

    /* Status Badges */
    .status-badge {
        padding: 0.4rem 0.8rem;
        border-radius: 20px;
        font-size: 0.75rem;
        font-weight: 600;
        text-transform: uppercase;
        letter-spacing: 0.5px;
    }

    .status-badge.new {
        background: rgba(52, 152, 219, 0.1);
        color: #3498db;
        border: 1px solid rgba(52, 152, 219, 0.3);
    }

    .status-badge.processed {
        background: rgba(243, 156, 18, 0.1);
        color: #f39c12;
        border: 1px solid rgba(243, 156, 18, 0.3);
    }

    .status-badge.completed {
        background: rgba(46, 204, 113, 0.1);
        color: #27ae60;
        border: 1px solid rgba(46, 204, 113, 0.3);
    }

    .status-badge.rejected {
        background: rgba(231, 76, 60, 0.1);
        color: #c0392b;
        border: 1px solid rgba(231, 76, 60, 0.3);
    }

    /* Quick Actions */
    .actions-list {
        display: flex;
        flex-direction: column;
        gap: 0.5rem;
    }

    .action-item {
        display: flex;
        align-items: center;
        gap: 0.75rem;
        padding: 1rem 1.25rem;
        background: #f8faff;
        border: 1px solid #e8eeff;
        border-radius: 10px;
        color: #2c3e50;
        text-decoration: none;
        transition: all 0.3s ease;
        font-weight: 500;
    }

    .action-item:hover {
        background: #667eea;
        color: white;
        transform: translateX(5px);
        text-decoration: none;
    }

    .action-item i {
        width: 16px;
        text-align: center;
    }

    /* System Info */
    .info-list {
        display: flex;
        flex-direction: column;
        gap: 1rem;
    }

    .info-item {
        display: flex;
        align-items: center;
        gap: 0.75rem;
        padding: 0.75rem 0;
        border-bottom: 1px solid #f1f3f4;
    }

    .info-item:last-child {
        border-bottom: none;
    }

    .info-item i {
        color: #667eea;
        width: 16px;
        text-align: center;
    }

    .info-label {
        flex: 1;
        color: #7f8c8d;
        font-size: 0.9rem;
    }

    .info-value {
        color: #2c3e50;
        font-weight: 600;
        font-size: 0.9rem;
    }

    /* Empty State */
    .empty-state {
        text-align: center;
        padding: 3rem 2rem;
        color: #7f8c8d;
    }

    .empty-icon {
        font-size: 3rem;
        margin-bottom: 1rem;
        opacity: 0.5;
    }

    .empty-state h4 {
        margin: 0 0 0.5rem 0;
        color: #2c3e50;
    }

    .empty-state p {
        margin: 0;
        font-size: 0.95rem;
    }

    /* Responsive Design */
    @media (max-width: 1024px) {
        .admin-grid {
            grid-template-columns: 1fr;
        }

        .admin-sidebar {
            grid-column: 1;
            flex-direction: row;
            flex-wrap: wrap;
        }

        .quick-actions,
        .system-info {
            flex: 1;
            min-width: 300px;
        }
    }

    @media (max-width: 768px) {
        .admin-header {
            margin-bottom: 1.5rem;
        }

        .page-title {
            font-size: 2rem;
        }

        .header-stats {
            grid-template-columns: 1fr;
        }

        .card-header {
            padding: 1.25rem 1.5rem;
            flex-direction: column;
            gap: 1rem;
            align-items: flex-start;
        }

        .card-body {
            padding: 1.25rem 1.5rem;
        }

        .application-item {
            padding: 1rem;
        }

        .application-header {
            flex-direction: column;
            align-items: flex-start;
            gap: 0.25rem;
        }

        .application-details {
            flex-direction: column;
            align-items: flex-start;
            gap: 0.5rem;
        }

        .admin-sidebar {
            flex-direction: column;
        }

        .quick-actions,
        .system-info {
            min-width: auto;
        }
    }

    /* Animations */
    @keyframes fadeInUp {
        from {
            opacity: 0;
            transform: translateY(20px);
        }
        to {
            opacity: 1;
            transform: translateY(0);
        }
    }

    .stat-item,
    .application-item,
    .action-item,
    .info-item {
        animation: fadeInUp 0.5s ease;
    }

    .stat-item:nth-child(1) { animation-delay: 0.1s; }
    .stat-item:nth-child(2) { animation-delay: 0.2s; }
    .stat-item:nth-child(3) { animation-delay: 0.3s; }

    .application-item:nth-child(1) { animation-delay: 0.2s; }
    .application-item:nth-child(2) { animation-delay: 0.3s; }
    .application-item:nth-child(3) { animation-delay: 0.4s; }
    .application-item:nth-child(4) { animation-delay: 0.5s; }
    .application-item:nth-child(5) { animation-delay: 0.6s; }
</style>

<script>
    document.addEventListener('DOMContentLoaded', function() {
        // Add click handlers for application items
        const applicationItems = document.querySelectorAll('.application-item');
        applicationItems.forEach(item => {
            item.addEventListener('click', function() {
                window.location = this.getAttribute('onclick').match(/'(.*?)'/)[1];
            });
        });

        // Add real-time clock update
        function updateClock() {
            const now = new Date();
            const timeElement = document.querySelector('.info-item:nth-child(2) .info-value');
            if (timeElement) {
                timeElement.textContent = now.toLocaleTimeString('ru-RU');
            }
        }

        setInterval(updateClock, 1000);

        // Add hover effects
        const statItems = document.querySelectorAll('.stat-item');
        statItems.forEach(item => {
            item.addEventListener('mouseenter', function() {
                this.style.transform = 'translateY(-3px) scale(1.02)';
            });

            item.addEventListener('mouseleave', function() {
                this.style.transform = 'translateY(0) scale(1)';
            });
        });
    });
</script>