<?php

use yii\helpers\Html;

/** @var yii\web\View $this */
/** @var int $totalApplications */
/** @var int $newApplications */
/** @var int $acceptedApplications */
/** @var int $errorApplications */
/** @var array $categoryStats */
/** @var array $userStats */

$this->title = 'Статистика';
$this->params['breadcrumbs'][] = $this->title;
?>

<div class="admin-statistics">
    <h1><?= Html::encode($this->title) ?></h1>

    <div class="row mt-4">
        <div class="col-md-3">
            <div class="card text-white bg-primary mb-3">
                <div class="card-body text-center">
                    <h2><?= $totalApplications ?></h2>
                    <p class="card-text">Всего заявок</p>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card text-white bg-warning mb-3">
                <div class="card-body text-center">
                    <h2><?= $newApplications ?></h2>
                    <p class="card-text">Новых заявок</p>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card text-white bg-success mb-3">
                <div class="card-body text-center">
                    <h2><?= $acceptedApplications ?></h2>
                    <p class="card-text">Принято заявок</p>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card text-white bg-danger mb-3">
                <div class="card-body text-center">
                    <h2><?= $errorApplications ?></h2>
                    <p class="card-text">Заявок с ошибками</p>
                </div>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="w-100">
            <div class="card">
                <div class="card-header">
                    <h5 class="card-title">Статистика по категориям</h5>
                </div>
                <div class="card-body">
                    <table class="table table-striped">
                        <thead>
                        <tr>
                            <th>Категория</th>
                            <th>Количество</th>
                            <th>Общая сумма</th>
                        </tr>
                        </thead>
                        <tbody>
                        <?php foreach ($categoryStats as $stat): ?>
                            <tr>
                                <td><?= \app\models\Application::getCategories()[$stat['category']] ?? $stat['category'] ?></td>
                                <td><?= $stat['count'] ?></td>
                                <td><?= number_format($stat['total_amount'], 2, ',', ' ') ?> руб.</td>
                            </tr>
                        <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>