<?php

use yii\helpers\Html;
use yii\widgets\ActiveForm;
use yii\bootstrap5\Alert;

/** @var yii\web\View $this */
/** @var app\models\Application $application */

$this->title = 'Заявка #' . $application->id;
$this->params['breadcrumbs'][] = ['label' => 'Заявки', 'url' => ['applications']];
$this->params['breadcrumbs'][] = $this->title;
?>

<div class="admin-view">
    <div class="row">
        <div class="col-md-8">
            <div class="card">
                <div class="card-header">
                    <h5 class="card-title">Информация о заявке</h5>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6">
                            <h6>Данные пользователя:</h6>
                            <p>
                                <strong>ФИО:</strong> <?= $application->user->last_name ?> <?= $application->user->first_name ?> <?= $application->user->patronymic ?><br>
                                <strong>Телефон:</strong> <?= $application->user->phone ?><br>
                                <strong>Email:</strong> <?= $application->user->email ?><br>
                                <strong>Адрес:</strong> <?= $application->user->address ?>
                            </p>
                        </div>
                        <div class="col-md-6">
                            <h6>Информация о заявке:</h6>
                            <p>
                                <strong>Дата создания:</strong> <?= Yii::$app->formatter->asDatetime($application->created_at) ?><br>
                                <strong>Дата показаний:</strong> <?= Yii::$app->formatter->asDate($application->date) ?><br>
                                <strong>Категория:</strong> <?= $application->getCategoryName() ?><br>
                                <strong>Статус:</strong> <span class="badge <?= $application->getStatusClass() ?>"><?= $application->getStatusName() ?></span>
                            </p>
                        </div>
                    </div>

                    <hr>

                    <div class="row">
                        <div class="col-md-6">
                            <h6>Показания счетчика:</h6>
                            <table class="table table-bordered">
                                <tr>
                                    <td><strong>Предыдущие показания:</strong></td>
                                    <td><?= number_format($application->previous_readings, 2, ',', ' ') ?></td>
                                </tr>
                                <tr>
                                    <td><strong>Текущие показания:</strong></td>
                                    <td><?= number_format($application->current_readings, 2, ',', ' ') ?></td>
                                </tr>
                                <tr>
                                    <td><strong>Расход:</strong></td>
                                    <td><?= number_format($application->consumption, 2, ',', ' ') ?></td>
                                </tr>
                            </table>
                        </div>
                        <div class="col-md-6">
                            <h6>Финансовые данные:</h6>
                            <table class="table table-bordered">
                                <tr>
                                    <td><strong>Тариф:</strong></td>
                                    <td><?= number_format($application->tariff, 2, ',', ' ') ?> руб.</td>
                                </tr>
                                <tr>
                                    <td><strong>Сумма к оплате:</strong></td>
                                    <td><strong><?= number_format($application->amount, 2, ',', ' ') ?> руб.</strong></td>
                                </tr>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-md-4">
            <div class="card">
                <div class="card-header">
                    <h5 class="card-title">Управление заявкой</h5>
                </div>
                <div class="card-body">
                    <?php $form = ActiveForm::begin(); ?>

                    <div class="mb-3">
                        <label class="form-label"><strong>Изменить статус:</strong></label>
                        <?= Html::dropDownList('status', $application->status, \app\models\Application::getAdminStatuses(), [
                            'class' => 'form-select',
                            'prompt' => 'Выберите статус'
                        ]) ?>
                    </div>

                    <div class="d-grid gap-2">
                        <?= Html::submitButton('Обновить статус', ['class' => 'btn btn-primary']) ?>
                        <?= Html::a('Вернуться к списку', ['applications'], ['class' => 'btn btn-secondary']) ?>
                    </div>

                    <?php ActiveForm::end(); ?>
                </div>
            </div>

        </div>
    </div>
</div>