<?php

/** @var yii\web\View $this */

$this->title = 'Коммунальные услуги - Главная';
?>
    <div class="site-index">

        <section class="hero-section">
            <div class="hero-background">
                <div class="hero-gradient"></div>
            </div>
            <div class="container">
                <div class="hero-content">
                    <div class="hero-text">
                        <h1 class="hero-title">Управляйте коммунальными услугами <span class="text-gradient">легко</span></h1>
                        <p class="hero-description">Сервис для передачи показаний счетчиков и управления вашими коммунальными платежами в одном месте</p>
                        <div class="hero-buttons">
                            <?php if (Yii::$app->user->isGuest): ?>
                                <?= yii\helpers\Html::a('Войти', ['/site/login'], ['class' => 'btn btn-primary btn-large']) ?>
                                <?= yii\helpers\Html::a('Регистрация', ['/site/register'], ['class' => 'btn btn-secondary btn-large']) ?>
                            <?php else: ?>
                                <?= yii\helpers\Html::a('Передать показания', ['/application/create'], ['class' => 'btn btn-primary btn-large']) ?>
                                <?= yii\helpers\Html::a('Мои заявки', ['/application/index'], ['class' => 'btn btn-secondary btn-large']) ?>
                            <?php endif; ?>
                        </div>
                    </div>
                    <div class="hero-visual">
                        <div class="floating-cards">
                            <div class="card-floating card-1">
                                <i class="fas fa-tachometer-alt"></i>
                                <span>Показания</span>
                            </div>
                            <div class="card-floating card-2">
                                <i class="fas fa-calculator"></i>
                                <span>Расчеты</span>
                            </div>
                            <div class="card-floating card-3">
                                <i class="fas fa-chart-line"></i>
                                <span>Статистика</span>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>

        <section class="features-section">
            <div class="container">
                <h2 class="section-title">Наши преимущества</h2>
                <div class="features-grid">
                    <div class="feature-card">
                        <div class="feature-icon">
                            <i class="fas fa-bolt"></i>
                        </div>
                        <h3>Мгновенная передача</h3>
                        <p>Передавайте показания счетчиков онлайн без очередей и бумажной волокиты</p>
                    </div>
                    <div class="feature-card">
                        <div class="feature-icon">
                            <i class="fas fa-calculator"></i>
                        </div>
                        <h3>Автоматический расчет</h3>
                        <p>Система автоматически рассчитывает сумму к оплате по действующим тарифам</p>
                    </div>
                    <div class="feature-card">
                        <div class="feature-icon">
                            <i class="fas fa-history"></i>
                        </div>
                        <h3>История платежей</h3>
                        <p>Вся история ваших показаний и платежей всегда под рукой</p>
                    </div>
                    <div class="feature-card">
                        <div class="feature-icon">
                            <i class="fas fa-shield-alt"></i>
                        </div>
                        <h3>Безопасность данных</h3>
                        <p>Ваши данные надежно защищены и хранятся в зашифрованном виде</p>
                    </div>
                </div>
            </div>
        </section>

        <section class="process-section">
            <div class="container">
                <h2 class="section-title">Как это работает</h2>
                <div class="process-steps">
                    <div class="process-step">
                        <div class="step-number">01</div>
                        <div class="step-content">
                            <h3>Регистрация</h3>
                            <p>Создайте аккаунт и заполните свой профиль</p>
                        </div>
                    </div>
                    <div class="process-step">
                        <div class="step-number">02</div>
                        <div class="step-content">
                            <h3>Передача показаний</h3>
                            <p>Передавайте показания счетчиков онлайн</p>
                        </div>
                    </div>
                    <div class="process-step">
                        <div class="step-number">03</div>
                        <div class="step-content">
                            <h3>Авторасчет</h3>
                            <p>Система автоматически рассчитывает сумму</p>
                        </div>
                    </div>
                    <div class="process-step">
                        <div class="step-number">04</div>
                        <div class="step-content">
                            <h3>История</h3>
                            <p>Следите за историей своих платежей</p>
                        </div>
                    </div>
                </div>
            </div>
        </section>

        <section class="tariffs-section">
            <div class="container">
                <h2 class="section-title">Тарифы</h2>
                <div class="tariffs-grid">
                    <div class="tariff-card">
                        <div class="tariff-header">
                            <div class="tariff-icon electricity">
                                <i class="fas fa-bolt"></i>
                            </div>
                            <h3>Электричество</h3>
                        </div>
                        <div class="tariff-price">5,03 ₽/кВт·ч</div>
                        <ul class="tariff-features">
                            <li><i class="fas fa-check"></i> Ежемесячная передача</li>
                            <li><i class="fas fa-check"></i> Автоматический расчет</li>
                            <li><i class="fas fa-check"></i> История потребления</li>
                        </ul>
                    </div>
                    <div class="tariff-card popular">
                        <div class="popular-badge">Популярный</div>
                        <div class="tariff-header">
                            <div class="tariff-icon water">
                                <i class="fas fa-tint"></i>
                            </div>
                            <h3>Вода</h3>
                        </div>
                        <div class="tariff-price">48,24 ₽/м³</div>
                        <ul class="tariff-features">
                            <li><i class="fas fa-check"></i> Холодная и горячая вода</li>
                            <li><i class="fas fa-check"></i> Раздельный учет</li>
                            <li><i class="fas fa-check"></i> Графики потребления</li>
                        </ul>
                    </div>
                    <div class="tariff-card">
                        <div class="tariff-header">
                            <div class="tariff-icon gas">
                                <i class="fas fa-fire"></i>
                            </div>
                            <h3>Газ</h3>
                        </div>
                        <div class="tariff-price">7,39 ₽/м³</div>
                        <ul class="tariff-features">
                            <li><i class="fas fa-check"></i> Простой ввод показаний</li>
                            <li><i class="fas fa-check"></i> Сравнение с прошлым месяцем</li>
                            <li><i class="fas fa-check"></i> Уведомления о платежах</li>
                        </ul>
                    </div>
                </div>
            </div>
        </section>

        <section class="cta-section">
            <div class="container">
                <div class="cta-content">
                    <h2>Готовы начать?</h2>
                    <p>Присоединяйтесь к тысячам довольных клиентов</p>
                    <div class="cta-buttons">
                        <?php if (Yii::$app->user->isGuest): ?>
                            <?= yii\helpers\Html::a('Начать сейчас', ['/site/register'], ['class' => 'btn btn-primary btn-large']) ?>
                        <?php else: ?>
                            <?= yii\helpers\Html::a('Передать показания', ['/application/create'], ['class' => 'btn btn-primary btn-large']) ?>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </section>

    </div>

    <style>
        /* Hero Section */
        .hero-section {
            position: relative;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            padding: 100px 0;
            overflow: hidden;
        }

        .hero-background {
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background: url('data:image/svg+xml,<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 1000 1000"><polygon fill="rgba(255,255,255,0.05)" points="0,1000 1000,0 1000,1000"/></svg>');
        }

        .hero-gradient {
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background: radial-gradient(circle at 20% 80%, rgba(120, 119, 198, 0.3) 0%, transparent 50%);
        }

        .hero-content {
            display: grid;
            grid-template-columns: 1fr 1fr;
            gap: 60px;
            align-items: center;
            position: relative;
            z-index: 2;
        }

        .hero-title {
            font-size: 3.5rem;
            font-weight: 700;
            line-height: 1.2;
            margin-bottom: 1.5rem;
        }

        .text-gradient {
            background: linear-gradient(45deg, #ffd89b, #19547b);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
            background-clip: text;
        }

        .hero-description {
            font-size: 1.25rem;
            margin-bottom: 2.5rem;
            opacity: 0.9;
            line-height: 1.6;
        }

        .hero-buttons {
            display: flex;
            gap: 1rem;
            flex-wrap: wrap;
        }

        .btn-large {
            padding: 1rem 2rem;
            font-size: 1.1rem;
            border-radius: 50px;
            text-decoration: none;
            font-weight: 600;
            transition: all 0.3s ease;
            border: none;
            cursor: pointer;
        }

        .btn-primary {
            background: linear-gradient(45deg, #ff6b6b, #ee5a24);
            color: white;
            box-shadow: 0 4px 15px rgba(255, 107, 107, 0.4);
        }

        .btn-primary:hover {
            transform: translateY(-2px);
            box-shadow: 0 8px 25px rgba(255, 107, 107, 0.6);
        }

        .btn-secondary {
            background: rgba(255, 255, 255, 0.1);
            color: white;
            backdrop-filter: blur(10px);
            border: 2px solid rgba(255, 255, 255, 0.2);
        }

        .btn-secondary:hover {
            background: rgba(255, 255, 255, 0.2);
            transform: translateY(-2px);
        }

        /* Floating Cards */
        .floating-cards {
            position: relative;
            height: 300px;
        }

        .card-floating {
            position: absolute;
            background: rgba(255, 255, 255, 0.1);
            backdrop-filter: blur(10px);
            border: 1px solid rgba(255, 255, 255, 0.2);
            border-radius: 20px;
            padding: 1.5rem;
            text-align: center;
            color: white;
            box-shadow: 0 8px 32px rgba(0, 0, 0, 0.1);
            transition: all 0.3s ease;
        }

        .card-1 {
            top: 20px;
            left: 0;
            animation: float 3s ease-in-out infinite;
        }

        .card-2 {
            top: 120px;
            right: 20px;
            animation: float 3s ease-in-out infinite 1s;
        }

        .card-3 {
            bottom: 40px;
            left: 60px;
            animation: float 3s ease-in-out infinite 2s;
        }

        .card-floating:hover {
            transform: translateY(-5px);
            background: rgba(255, 255, 255, 0.15);
        }

        .card-floating i {
            font-size: 2rem;
            margin-bottom: 0.5rem;
            display: block;
        }

        @keyframes float {
            0%, 100% { transform: translateY(0); }
            50% { transform: translateY(-10px); }
        }

        /* Sections Common */
        section {
            padding: 80px 0;
        }

        .section-title {
            text-align: center;
            font-size: 2.5rem;
            font-weight: 700;
            margin-bottom: 3rem;
            color: #2c3e50;
        }

        /* Features Section */
        .features-section {
            background: #f8f9fa;
        }

        .features-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(280px, 1fr));
            gap: 2rem;
        }

        .feature-card {
            background: white;
            padding: 2.5rem 2rem;
            border-radius: 20px;
            text-align: center;
            box-shadow: 0 10px 30px rgba(0, 0, 0, 0.1);
            transition: all 0.3s ease;
            border: 1px solid #f0f0f0;
        }

        .feature-card:hover {
            transform: translateY(-10px);
            box-shadow: 0 20px 40px rgba(0, 0, 0, 0.15);
        }

        .feature-icon {
            width: 80px;
            height: 80px;
            margin: 0 auto 1.5rem;
            background: linear-gradient(135deg, #667eea, #764ba2);
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            color: white;
            font-size: 2rem;
        }

        .feature-card h3 {
            font-size: 1.5rem;
            margin-bottom: 1rem;
            color: #2c3e50;
        }

        .feature-card p {
            color: #7f8c8d;
            line-height: 1.6;
        }

        /* Process Section */
        .process-steps {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
            gap: 2rem;
        }

        .process-step {
            text-align: center;
            position: relative;
        }

        .step-number {
            font-size: 3rem;
            font-weight: 800;
            color: #e0e0e0;
            margin-bottom: 1rem;
            line-height: 1;
        }

        .step-content h3 {
            font-size: 1.5rem;
            margin-bottom: 1rem;
            color: #2c3e50;
        }

        .step-content p {
            color: #7f8c8d;
            line-height: 1.6;
        }

        /* Tariffs Section */
        .tariffs-section {
            background: #f8f9fa;
        }

        .tariffs-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(300px, 1fr));
            gap: 2rem;
        }

        .tariff-card {
            background: white;
            padding: 2.5rem;
            border-radius: 20px;
            box-shadow: 0 10px 30px rgba(0, 0, 0, 0.1);
            transition: all 0.3s ease;
            position: relative;
            border: 2px solid transparent;
        }

        .tariff-card:hover {
            transform: translateY(-5px);
            box-shadow: 0 20px 40px rgba(0, 0, 0, 0.15);
        }

        .tariff-card.popular {
            border-color: #ff6b6b;
            transform: scale(1.05);
        }

        .popular-badge {
            position: absolute;
            top: -10px;
            left: 50%;
            transform: translateX(-50%);
            background: linear-gradient(45deg, #ff6b6b, #ee5a24);
            color: white;
            padding: 0.5rem 1.5rem;
            border-radius: 20px;
            font-size: 0.875rem;
            font-weight: 600;
        }

        .tariff-header {
            text-align: center;
            margin-bottom: 2rem;
        }

        .tariff-icon {
            width: 80px;
            height: 80px;
            margin: 0 auto 1rem;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 2rem;
            color: white;
        }

        .tariff-icon.electricity {
            background: linear-gradient(135deg, #f093fb, #f5576c);
        }

        .tariff-icon.water {
            background: linear-gradient(135deg, #4facfe, #00f2fe);
        }

        .tariff-icon.gas {
            background: linear-gradient(135deg, #43e97b, #38f9d7);
        }

        .tariff-header h3 {
            font-size: 1.5rem;
            color: #2c3e50;
            margin: 0;
        }

        .tariff-price {
            font-size: 2rem;
            font-weight: 700;
            text-align: center;
            color: #2c3e50;
            margin-bottom: 2rem;
        }

        .tariff-features {
            list-style: none;
            padding: 0;
            margin: 0;
        }

        .tariff-features li {
            padding: 0.75rem 0;
            border-bottom: 1px solid #f0f0f0;
            color: #7f8c8d;
        }

        .tariff-features li:last-child {
            border-bottom: none;
        }

        .tariff-features i {
            color: #27ae60;
            margin-right: 0.5rem;
        }

        /* CTA Section */
        .cta-section {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            text-align: center;
        }

        .cta-content h2 {
            font-size: 2.5rem;
            margin-bottom: 1rem;
        }

        .cta-content p {
            font-size: 1.25rem;
            margin-bottom: 2rem;
            opacity: 0.9;
        }

        .cta-buttons .btn-primary {
            background: linear-gradient(45deg, #ffd89b, #19547b);
        }

        /* Responsive Design */
        @media (max-width: 768px) {
            .hero-content {
                grid-template-columns: 1fr;
                text-align: center;
            }

            .hero-title {
                font-size: 2.5rem;
            }

            .floating-cards {
                height: 200px;
                margin-top: 2rem;
            }

            .tariff-card.popular {
                transform: none;
            }

            .hero-buttons {
                justify-content: center;
            }

            .btn-large {
                padding: 0.875rem 1.5rem;
                font-size: 1rem;
            }
        }
    </style>

<?php
$this->registerJs(<<<JS
    // Add scroll animations
    const observerOptions = {
        threshold: 0.1,
        rootMargin: '0px 0px -50px 0px'
    };

    const observer = new IntersectionObserver((entries) => {
        entries.forEach(entry => {
            if (entry.isIntersecting) {
                entry.target.style.opacity = '1';
                entry.target.style.transform = 'translateY(0)';
            }
        });
    }, observerOptions);

    // Observe all feature cards and process steps
    document.querySelectorAll('.feature-card, .process-step, .tariff-card').forEach(el => {
        el.style.opacity = '0';
        el.style.transform = 'translateY(30px)';
        el.style.transition = 'opacity 0.6s ease, transform 0.6s ease';
        observer.observe(el);
    });
JS
);
?>