<?php

/** @var yii\web\View $this */
/** @var yii\bootstrap5\ActiveForm $form */

/** @var app\models\LoginForm $model */

use yii\bootstrap5\ActiveForm;
use yii\bootstrap5\Html;

$this->title = 'Авторизация';
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="site-login">
    <div class="login-container">
        <div class="login-card">
            <div class="login-header">
                <div class="login-icon">
                    <i class="fas fa-sign-in-alt"></i>
                </div>
                <h1 class="login-title"><?= Html::encode($this->title) ?></h1>
                <p class="login-subtitle">Войдите в свой аккаунт для управления коммунальными услугами</p>
            </div>

            <div class="login-form-container">
                <?php $form = ActiveForm::begin([
                    'id' => 'login-form',
                    'options' => ['class' => 'login-form'],
                    'fieldConfig' => [
                        'template' => "{label}\n{input}\n{error}",
                        'labelOptions' => ['class' => 'form-label'],
                        'inputOptions' => ['class' => 'form-input'],
                        'errorOptions' => ['class' => 'form-error'],
                    ],
                ]); ?>

                <div class="form-group">
                    <?= $form->field($model, 'phone', [
                        'template' => '
                            <div class="input-group">
                                <span class="input-icon">
                                    <i class="fas fa-phone"></i>
                                </span>
                                {input}
                            </div>
                            {label}
                            {error}
                        ',
                        'labelOptions' => ['class' => 'form-label'],
                        'inputOptions' => [
                            'class' => 'form-input',
                            'placeholder' => '8(999)999-99-99'
                        ]
                    ])->widget(\yii\widgets\MaskedInput::class, [
                        'mask' => '8(999)999-99-99',
                    ]) ?>
                </div>

                <div class="form-group">
                    <?= $form->field($model, 'password', [
                        'template' => '
                            <div class="input-group">
                                <span class="input-icon">
                                    <i class="fas fa-lock"></i>
                                </span>
                                {input}
                                <button type="button" class="password-toggle" onclick="togglePassword(\'' . Html::getInputId($model, 'password') . '\')">
                                    <i class="fas fa-eye"></i>
                                </button>
                            </div>
                            {label}
                            {error}
                        ',
                        'labelOptions' => ['class' => 'form-label'],
                        'inputOptions' => [
                            'class' => 'form-input',
                            'placeholder' => 'Введите ваш пароль'
                        ]
                    ])->passwordInput() ?>
                </div>

                <div class="form-actions">
                    <?= Html::submitButton('Войти', [
                        'class' => 'btn-login',
                        'name' => 'login-button'
                    ]) ?>
                </div>

                <div class="form-footer">
                    <p class="register-link">
                        Еще не зарегистрированы?
                        <?= Html::a('Регистрация', ['site/register'], ['class' => 'register-link-text']) ?>
                    </p>
                </div>

                <?php ActiveForm::end(); ?>
            </div>
        </div>

        <div class="login-features">
            <div class="feature-item">
                <div class="feature-icon">
                    <i class="fas fa-shield-alt"></i>
                </div>
                <h3>Безопасный вход</h3>
                <p>Ваши данные защищены современными методами шифрования</p>
            </div>
            <div class="feature-item">
                <div class="feature-icon">
                    <i class="fas fa-bolt"></i>
                </div>
                <h3>Мгновенный доступ</h3>
                <p>Получите доступ ко всем функциям сразу после входа</p>
            </div>
            <div class="feature-item">
                <div class="feature-icon">
                    <i class="fas fa-chart-line"></i>
                </div>
                <h3>Управление услугами</h3>
                <p>Контролируйте все коммунальные платежи в одном месте</p>
            </div>
        </div>
    </div>
</div>

<style>
    /* Login Container */
    .site-login {
        min-height: 100vh;
        background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
        display: flex;
        align-items: center;
        justify-content: center;
        padding: 2rem 1rem;
        position: relative;
    }

    .site-login::before {
        content: '';
        position: absolute;
        top: 0;
        left: 0;
        right: 0;
        bottom: 0;
        background: url('data:image/svg+xml,<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 1000 1000"><circle fill="rgba(255,255,255,0.05)" cx="200" cy="200" r="100"/><circle fill="rgba(255,255,255,0.03)" cx="800" cy="300" r="150"/><circle fill="rgba(255,255,255,0.04)" cx="400" cy="700" r="120"/></svg>');
    }

    .login-container {
        display: grid;
        grid-template-columns: 1fr 1fr;
        gap: 3rem;
        max-width: 1200px;
        width: 100%;
        align-items: center;
        position: relative;
        z-index: 2;
    }

    /* Login Card */
    .login-card {
        background: rgba(255, 255, 255, 0.95);
        backdrop-filter: blur(20px);
        border-radius: 24px;
        box-shadow: 0 20px 60px rgba(0, 0, 0, 0.2);
        overflow: hidden;
    }

    .login-header {
        background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
        color: white;
        padding: 2.5rem 2rem;
        text-align: center;
        position: relative;
    }

    .login-header::before {
        content: '';
        position: absolute;
        top: 0;
        left: 0;
        right: 0;
        bottom: 0;
        background: url('data:image/svg+xml,<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 1000 1000"><polygon fill="rgba(255,255,255,0.1)" points="0,800 1000,400 1000,800"/></svg>');
    }

    .login-icon {
        position: relative;
        z-index: 2;
        font-size: 2.5rem;
        margin-bottom: 1rem;
    }

    .login-title {
        position: relative;
        z-index: 2;
        font-size: 2rem;
        font-weight: 700;
        margin-bottom: 0.5rem;
    }

    .login-subtitle {
        position: relative;
        z-index: 2;
        font-size: 1rem;
        opacity: 0.9;
        margin: 0;
    }

    /* Form Styles */
    .login-form-container {
        padding: 2.5rem 2rem;
    }

    .form-group {
        margin-bottom: 1.5rem;
    }

    .input-group {
        position: relative;
        display: flex;
        align-items: center;
        margin-bottom: 0.5rem;
    }

    .input-icon {
        position: absolute;
        left: 1rem;
        z-index: 2;
        color: #667eea;
        font-size: 1rem;
    }

    .form-input {
        width: 100%;
        padding: 1rem 1rem 1rem 3rem;
        border: 2px solid #e8eeff;
        border-radius: 12px;
        font-size: 1rem;
        background: #f8faff;
        transition: all 0.3s ease;
        outline: none;
    }

    .form-input:focus {
        border-color: #667eea;
        background: white;
        box-shadow: 0 0 0 3px rgba(102, 126, 234, 0.1);
        transform: translateY(-2px);
    }

    .form-input::placeholder {
        color: #a0a4c1;
    }

    .form-label {
        display: block;
        margin-bottom: 0.5rem;
        font-weight: 600;
        color: #2d3748;
        font-size: 0.95rem;
    }

    .password-toggle {
        position: absolute;
        right: 1rem;
        background: none;
        border: none;
        color: #a0a4c1;
        cursor: pointer;
        font-size: 1rem;
        transition: color 0.3s ease;
        z-index: 2;
    }

    .password-toggle:hover {
        color: #667eea;
    }

    .form-error {
        color: #ff4757;
        font-size: 0.875rem;
        margin-top: 0.5rem;
        display: block;
    }

    /* Button Styles */
    .form-actions {
        text-align: center;
        margin: 2rem 0 1.5rem;
    }

    .btn-login {
        background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
        color: white;
        border: none;
        padding: 1.25rem 3rem;
        font-size: 1.1rem;
        font-weight: 600;
        border-radius: 50px;
        cursor: pointer;
        transition: all 0.3s ease;
        box-shadow: 0 10px 30px rgba(102, 126, 234, 0.4);
        position: relative;
        overflow: hidden;
        width: 100%;
        max-width: 300px;
    }

    .btn-login::before {
        content: '';
        position: absolute;
        top: 0;
        left: -100%;
        width: 100%;
        height: 100%;
        background: linear-gradient(90deg, transparent, rgba(255,255,255,0.3), transparent);
        transition: left 0.5s;
    }

    .btn-login:hover::before {
        left: 100%;
    }

    .btn-login:hover {
        transform: translateY(-3px);
        box-shadow: 0 15px 40px rgba(102, 126, 234, 0.6);
    }

    .btn-login:active {
        transform: translateY(-1px);
    }

    /* Footer Links */
    .form-footer {
        text-align: center;
        padding-top: 1.5rem;
        border-top: 1px solid #e8eeff;
    }

    .register-link {
        color: #718096;
        margin: 0;
        font-size: 0.95rem;
    }

    .register-link-text {
        color: #667eea;
        text-decoration: none;
        font-weight: 600;
        transition: color 0.3s ease;
    }

    .register-link-text:hover {
        color: #764ba2;
        text-decoration: underline;
    }

    /* Features Section */
    .login-features {
        display: flex;
        flex-direction: column;
        gap: 2rem;
    }

    .feature-item {
        background: rgba(255, 255, 255, 0.1);
        backdrop-filter: blur(10px);
        border: 1px solid rgba(255, 255, 255, 0.2);
        border-radius: 16px;
        padding: 2rem;
        color: white;
        text-align: center;
        transition: all 0.3s ease;
    }

    .feature-item:hover {
        background: rgba(255, 255, 255, 0.15);
        transform: translateY(-5px);
    }

    .feature-icon {
        font-size: 2.5rem;
        margin-bottom: 1rem;
        color: #ffd93d;
    }

    .feature-item h3 {
        font-size: 1.25rem;
        font-weight: 600;
        margin-bottom: 0.75rem;
    }

    .feature-item p {
        opacity: 0.9;
        line-height: 1.5;
        margin: 0;
    }

    /* Responsive Design */
    @media (max-width: 968px) {
        .login-container {
            grid-template-columns: 1fr;
            gap: 2rem;
            max-width: 500px;
        }

        .login-features {
            flex-direction: row;
            flex-wrap: wrap;
        }

        .feature-item {
            flex: 1;
            min-width: 200px;
        }
    }

    @media (max-width: 768px) {
        .login-card {
            margin: 1rem;
        }

        .login-header {
            padding: 2rem 1.5rem;
        }

        .login-form-container {
            padding: 2rem 1.5rem;
        }

        .login-title {
            font-size: 1.75rem;
        }

        .btn-login {
            width: 100%;
            padding: 1.25rem 2rem;
        }

        .login-features {
            flex-direction: column;
        }
    }

    /* Animation for form elements */
    @keyframes fadeInUp {
        from {
            opacity: 0;
            transform: translateY(20px);
        }
        to {
            opacity: 1;
            transform: translateY(0);
        }
    }

    .form-group {
        animation: fadeInUp 0.5s ease forwards;
    }

    .form-group:nth-child(1) { animation-delay: 0.1s; }
    .form-group:nth-child(2) { animation-delay: 0.2s; }

    .feature-item {
        animation: fadeInUp 0.5s ease forwards;
    }

    .feature-item:nth-child(1) { animation-delay: 0.3s; }
    .feature-item:nth-child(2) { animation-delay: 0.4s; }
    .feature-item:nth-child(3) { animation-delay: 0.5s; }

    /* Loading state for button */
    .btn-login.loading {
        pointer-events: none;
        opacity: 0.8;
    }

    .btn-login.loading::after {
        content: '';
        position: absolute;
        width: 20px;
        height: 20px;
        top: 50%;
        left: 50%;
        margin-left: -10px;
        margin-top: -10px;
        border: 2px solid transparent;
        border-top: 2px solid white;
        border-radius: 50%;
        animation: spin 1s linear infinite;
    }

    @keyframes spin {
        0% { transform: rotate(0deg); }
        100% { transform: rotate(360deg); }
    }
</style>

<script>
    function togglePassword(inputId) {
        const input = document.getElementById(inputId);
        const icon = input.parentNode.querySelector('.password-toggle i');

        if (input.type === 'password') {
            input.type = 'text';
            icon.classList.remove('fa-eye');
            icon.classList.add('fa-eye-slash');
        } else {
            input.type = 'password';
            icon.classList.remove('fa-eye-slash');
            icon.classList.add('fa-eye');
        }
    }

    // Add form submission loading state
    document.addEventListener('DOMContentLoaded', function() {
        const loginForm = document.getElementById('login-form');
        const loginButton = document.querySelector('.btn-login');

        if (loginForm) {
            loginForm.addEventListener('submit', function() {
                loginButton.classList.add('loading');
                loginButton.innerHTML = '<span style="opacity: 0;">Войти</span>';
            });
        }

        // Add focus effects
        const inputs = document.querySelectorAll('.form-input');

        inputs.forEach(input => {
            input.addEventListener('focus', function() {
                this.parentNode.classList.add('focused');
            });

            input.addEventListener('blur', function() {
                this.parentNode.classList.remove('focused');
            });
        });
    });
</script>